BEGIN TRANSACTION;
DROP TABLE IF EXISTS 'Config' ;
DROP TABLE IF EXISTS 'ImageProcessing' ;
DROP TABLE IF EXISTS 'Images' ;
DROP TABLE IF EXISTS 'Patients' ;
DROP TABLE IF EXISTS 'ResectionPlans' ;
DROP TABLE IF EXISTS 'Series' ;
DROP TABLE IF EXISTS 'Studies' ;

CREATE TABLE 'Config' (
  'Key' VARCHAR(255) NOT NULL ,
  'Value' VARCHAR(1024) NULL ,
  PRIMARY KEY ('Key') );
CREATE TABLE 'ImageProcessing' (
  'SeriesInstanceUID' VARCHAR(255) NOT NULL ,
  'LiverSegmentationAttempted' BOOL NOT NULL ,
  'LiverSegmentationFile' VARCHAR(1024) NULL ,
  'LiverSegmentationParameters' VARCHAR(1024) NULL ,
  'LiverMeshFile' VARCHAR(1024) NULL ,
  PRIMARY KEY ('SeriesInstanceUID') );
CREATE TABLE 'Images' (
  'Filename' VARCHAR(1024) NOT NULL ,
  'SeriesInstanceUID' VARCHAR(255) NOT NULL ,
  PRIMARY KEY ('Filename') );
CREATE TABLE 'Patients' (
  'UID' INTEGER PRIMARY KEY AUTOINCREMENT,
  'PatientsName' VARCHAR(255) NULL ,
  'PatientID' VARCHAR(255) NULL ,
  'PatientsBirthDate' DATE NULL ,
  'PatientsBirthTime' TIME NULL ,
  'PatientsSex' varchar(1) NULL ,
  'PatientsComments' VARCHAR(255) NULL );
CREATE TABLE 'ResectionPlans' (
  'SeriesInstanceUID' VARCHAR(255) NOT NULL ,
  'PlanID' INTEGER NOT NULL,
  'Description' VARCHAR(255) NULL ,
  'PlannersName' VARCHAR(255) NULL ,
  'ResectionPlanLabeledImageFile' VARCHAR(1024) NOT NULL ,
  'ResectionPlanSurfaceFile' VARCHAR(1024) NOT NULL,
  PRIMARY KEY ('SeriesInstanceUID', 'PlanID') );
CREATE TABLE 'Series' (
  'SeriesInstanceUID' VARCHAR(255) NOT NULL ,
  'StudyInstanceUID' VARCHAR(45) NOT NULL ,
  'SeriesNumber' INT NULL ,
  'SeriesDate' DATE NULL ,
  'SeriesTime' VARCHAR(20) NULL ,
  'SeriesDescription' VARCHAR(255) NULL ,
  'BodyPartExamined' VARCHAR(255) NULL ,
  'FrameOfReferenceUID' VARCHAR(255) NULL ,
  'AcquisitionNumber' INT NULL ,
  'ContrastAgent' VARCHAR(255) NULL ,
  'ScanningSequence' VARCHAR(45) NULL ,
  'EchoNumber' INT NULL ,
  'TemporalPosition' INT NULL ,
  PRIMARY KEY ('SeriesInstanceUID') );
CREATE TABLE 'Studies' (
  'StudyInstanceUID' VARCHAR(255) NOT NULL ,
  'PatientsUID' INT NOT NULL ,
  'StudyID' VARCHAR(255) NULL ,
  'StudyDate' DATE NULL ,
  'StudyTime' VARCHAR(20) NULL ,
  'AccessionNumber' VARCHAR(255) NULL ,
  'ModalitiesInStudy' VARCHAR(255) NULL ,
  'ReferringPhysician' VARCHAR(255) NULL ,
  'StudyDescription' VARCHAR(255) NULL ,
  PRIMARY KEY ('StudyInstanceUID') );
COMMIT;

