/*=============================================================================

  Library: XNAT/Core

  Copyright (c) University College London,
    Centre for Medical Image Computing

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

=============================================================================*/

#ifndef ctkXnatExperiment_h
#define ctkXnatExperiment_h

#include "ctkXNATCoreExport.h"

#include "ctkXnatObject.h"
#include "ctkXnatDefaultSchemaTypes.h"

class ctkXnatExperimentPrivate;

/**
 * @ingroup XNAT_Core
 */
class CTK_XNAT_CORE_EXPORT ctkXnatExperiment : public ctkXnatObject
{

public:

  ctkXnatExperiment(ctkXnatObject* parent = 0, const QString& schemaType = ctkXnatDefaultSchemaTypes::XSI_EXPERIMENT);

  virtual ~ctkXnatExperiment();

  virtual QString resourceUri() const;

  /// Sets the name, i.e. the label of the subject
  virtual void setName(const QString &name);
  /// Returns the name, i.e. the label of the subject
  virtual QString name() const;

  void setLabel(const QString &label);
  QString label() const;

  QString dateOfAcquisition() const;
  void setDateOfAcquisition(const QString &dateOfAcquisition);

  QString timeOfAcquisition() const;
  void setTimeOfAcquisition(const QString &timeOfAcquisition);

  QString scannerType() const;
  void setScannerType(const QString &scannerType);

  QString imageModality() const;
  void setImageModality(const QString &imageModality);

  void reset();

  static const QString DATE_OF_ACQUISITION;
  static const QString TIME_OF_ACQUISITION;
  static const QString SCANNER_TYPE;
  static const QString IMAGE_MODALITY;

private:

  virtual void fetchImpl();

  virtual void downloadImpl(const QString&);

  Q_DECLARE_PRIVATE(ctkXnatExperiment)
};

#endif
