
#!
#! See http://www.cmake.org/Wiki/CMakeMacroParseArguments
#!
#! \ingroup CMakeUtilities
macro(CtkMacroParseArguments prefix arg_names option_names)
  set(DEFAULT_ARGS)
  foreach(arg_name ${arg_names})
    set(${prefix}_${arg_name})
  endforeach()
  foreach(option ${option_names})
    set(${prefix}_${option} FALSE)
  endforeach()

  set(current_arg_name DEFAULT_ARGS)
  set(current_arg_list)
  foreach(arg ${ARGN})
    set(larg_names ${arg_names})
    list(FIND larg_names "${arg}" is_arg_name)
    IF (is_arg_name GREATER -1)
      set(${prefix}_${current_arg_name} ${current_arg_list})
      set(current_arg_name ${arg})
      set(current_arg_list)
    ELSE (is_arg_name GREATER -1)
      set(loption_names ${option_names})    
      list(FIND loption_names "${arg}" is_option)
      IF (is_option GREATER -1)
        set(${prefix}_${arg} TRUE)
      ELSE (is_option GREATER -1)
        set(current_arg_list ${current_arg_list} ${arg})
      ENDIF (is_option GREATER -1)
    ENDIF (is_arg_name GREATER -1)
  endforeach()
  set(${prefix}_${current_arg_name} ${current_arg_list})
endmacro()
