###########################################################################
#
#  Library:   CTK
#
#  Copyright (c) Kitware Inc.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0.txt
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
###########################################################################

#
# ctkScriptMocPythonQtWrapper
#

#
# This script should be invoked either as a CUSTOM_COMMAND 
# or from the command line using the following syntax:
#
#    cmake -DWRAPPING_NAMESPACE:STRING=org.commontk -DTARGET:STRING=MyLib
#          -DOUTPUT_DIR:PATH=/path -DINCLUDE_DIRS:STRING=/path1:/path2
#          -DWRAPPER_MASTER_MOC_FILE:FILEPATH=/path/to/file
#          -DQT_QMAKE_EXECUTABLE:PATH=/path/to/qt/qmake
#           -P ctkScriptWrapPythonQt.cmake
#
#

# Check for non-defined var
foreach(var WRAPPING_NAMESPACE TARGET MOC_FLAGS WRAPPER_MASTER_MOC_FILE WRAP_INT_DIR)
  if(NOT DEFINED ${var})
    message(FATAL_ERROR "${var} not specified when calling ctkScriptMocPythonQtWrapper")
  endif()
endforeach()

# Check for non-existing ${var}
foreach(var OUTPUT_DIR QT_MOC_EXECUTABLE)
  if(NOT EXISTS ${${var}})
    message(FATAL_ERROR "Failed to find ${var} when calling ctkScriptWrapPythonQt")
  endif()
endforeach()

# Convert wrapping namespace to subdir
string(REPLACE "." "_" WRAPPING_NAMESPACE_UNDERSCORE ${WRAPPING_NAMESPACE})

# Read moc flags from file
if(WIN32)
  if(NOT EXISTS ${MOC_FLAGS})
    message(FATAL_ERROR "On Windows, MOC_FLAGS should be the name of the file containing the moc flags !")
  endif()
  file(READ ${MOC_FLAGS} MOC_FLAGS)
endif()

# Convert ^^ separated string to list
string(REPLACE "^^" ";" MOC_FLAGS "${MOC_FLAGS}")

# Clear file where all moc'ified will be appended
file(WRITE ${WRAPPER_MASTER_MOC_FILE} "// 
// File auto-generated by cmake macro ctkScriptMocPythonQtWrapper\n//\n")

# Collect wrapper headers
set(glob_expression ${OUTPUT_DIR}/${WRAP_INT_DIR}${WRAPPING_NAMESPACE_UNDERSCORE}_${TARGET}*.h)
file(GLOB wrapper_headers RELATIVE ${OUTPUT_DIR}/${WRAP_INT_DIR} ${glob_expression})

if(NOT wrapper_headers)
  message(FATAL_ERROR "ctkScriptMocPythonQtWrapper - Failed to glob wrapper headers using expression:[${glob_expression}]")
endif()

# Moc'ified each one of them
foreach(header ${wrapper_headers})

  # what is the filename without the extension
  get_filename_component(TMP_FILENAME ${header} NAME_WE)
  
  set(moc_options)
  set(wrapper_h_file ${OUTPUT_DIR}/${WRAP_INT_DIR}/${header})
  set(wrapper_moc_file ${OUTPUT_DIR}/${WRAP_INT_DIR}/moc_${header}.cpp)
  #message("wrapper_h_file: ${wrapper_h_file}")
  #message("wrapper_moc_file: ${wrapper_moc_file}")
  execute_process(
    COMMAND ${QT_MOC_EXECUTABLE} ${MOC_FLAGS} ${moc_options} -o ${wrapper_moc_file} ${wrapper_h_file}
    WORKING_DIRECTORY ${OUTPUT_DIR}
    RESULT_VARIABLE RESULT_VAR
    ERROR_VARIABLE error
    )
  if(RESULT_VAR)
    message(FATAL_ERROR "Failed to moc'ified .\n${RESULT_VAR}\n${error}")
  endif()
  
  # Append generated moc file to the master file
  file(READ ${wrapper_moc_file} file_content)
  file(APPEND ${WRAPPER_MASTER_MOC_FILE} "${file_content}")

endforeach()

