

#
# Based on ParaView/VTK/Utilities/vtkTclTest2Py/CMakeLists.txt and
#          ParaView/VTK/Wrapping/Python/CMakeLists.txt
#

include(${CTK_CMAKE_DIR}/ctkMacroParseArguments.cmake)

#! \ingroup CMakeAPI
macro(ctkMacroCompilePythonScript)
  ctkMacroParseArguments(MY
    "TARGET_NAME;SCRIPTS;RESOURCES;SOURCE_DIR;DESTINATION_DIR;INSTALL_DIR"
    "NO_INSTALL_SUBDIR"
    ${ARGN}
    )

  find_package(PythonInterp REQUIRED)
  find_package(PythonLibs REQUIRED)

  # Extract python lib path
  get_filename_component(PYTHON_LIBRARY_PATH ${PYTHON_LIBRARY} PATH)
  
  # Sanity checks
  foreach(varname TARGET_NAME SCRIPTS DESTINATION_DIR INSTALL_DIR)
    if(NOT DEFINED MY_${varname})
      message(FATAL_ERROR "${varname} is mandatory")
    endif()
  endforeach()

  if(NOT DEFINED MY_SOURCE_DIR)
    set(MY_SOURCE_DIR ${CMAKE_CURRENT_SOURCE_DIR})
  endif()

  # Since 'add_custom_command' doesn't play nicely with path having multiple
  # consecutive slashes. Let's make sure there are no trailing slashes.
  get_filename_component(MY_SOURCE_DIR ${MY_SOURCE_DIR} REALPATH)
  get_filename_component(MY_DESTINATION_DIR ${MY_DESTINATION_DIR} REALPATH)

  set(input_python_files)
  set(copied_python_files)
  foreach(file ${MY_SCRIPTS})
    # Append "py" extension if needed
    get_filename_component(file_ext ${file} EXT)
    if(NOT "${file_ext}" MATCHES "py")
      set(file "${file}.py")
    endif()

    set(src "${MY_SOURCE_DIR}/${file}")
    set(tgt "${MY_DESTINATION_DIR}/${file}")
    if(IS_ABSOLUTE ${file})
      set(src ${file})
      file(RELATIVE_PATH tgt_file ${CMAKE_CURRENT_BINARY_DIR} ${file})
      set(tgt "${MY_DESTINATION_DIR}/${tgt_file}")
    endif()

    list(APPEND input_python_files ${src})
    add_custom_command(DEPENDS ${src}
                        COMMAND ${CMAKE_COMMAND} -E copy ${src} ${tgt}
                        OUTPUT ${tgt}
                        COMMENT "Copying python script: ${file}")
    list(APPEND copied_python_files ${tgt})
  endforeach()
  
  add_custom_target(Copy${MY_TARGET_NAME}PythonFiles DEPENDS ${input_python_files} ${copied_python_files})
  
  # Byte compile the Python files.
  set(compile_all_script "${CMAKE_CURRENT_BINARY_DIR}/compile_${MY_TARGET_NAME}_python_scripts.py")
  
  # Generate compile_${MY_TARGET_NAME}_python_scripts.py
  file(WRITE ${compile_all_script} "
#
# Generated by ctkMacroCompilePythonScript CMAKE macro
#

# Based on paraview/VTK/Wrapping/Python/compile_all_vtk.py.in

import compileall
compileall.compile_dir('@MY_DESTINATION_DIR@')
file = open('@CMAKE_CURRENT_BINARY_DIR@/python_compile_@MY_TARGET_NAME@_complete', 'w')
file.write('Done')
")

  # Configure cmake script associated with the custom command
  # required to properly update the library path with PYTHON_LIBRARY_PATH
  set(compile_all_cmake_script "${CMAKE_CURRENT_BINARY_DIR}/compile_${MY_TARGET_NAME}_python_scripts.cmake")
  file(WRITE ${compile_all_cmake_script} "
#
# Generated by ctkMacroCompilePythonScript CMAKE macro
#

if(WIN32)
    set(ENV{PATH} \"@PYTHON_LIBRARY_PATH@;\$ENV{PATH}\")
elseif(APPLE)
  set(ENV{DYLD_LIBRARY_PATH} \"@PYTHON_LIBRARY_PATH@:\$ENV{DYLD_LIBRARY_PATH}\")
else()
  set(ENV{LD_LIBRARY_PATH} \"@PYTHON_LIBRARY_PATH@:\$ENV{LD_LIBRARY_PATH}\")
endif()

execute_process(
  COMMAND \"@PYTHON_EXECUTABLE@\" \"@compile_all_script@\"
  )
")

  add_custom_command(
    COMMAND ${CMAKE_COMMAND} -P ${compile_all_cmake_script}
    DEPENDS ${copied_python_files}  ${compile_all_script}
    OUTPUT "${CMAKE_CURRENT_BINARY_DIR}/python_compile_${MY_TARGET_NAME}_complete"
    COMMENT "Compiling python scripts: ${MY_TARGET_NAME}"
    )

  add_custom_target(Compile${MY_TARGET_NAME}PythonFiles ALL
    DEPENDS 
      ${CMAKE_CURRENT_BINARY_DIR}/python_compile_${MY_TARGET_NAME}_complete
      ${compile_all_script}
      )
      
  if(DEFINED MY_RESOURCES)
    set(resource_input_files)
    set(copied_resource_files)
    foreach(file ${MY_RESOURCES})
      set(src "${CMAKE_CURRENT_SOURCE_DIR}/${file}")
      set(tgt "${MY_DESTINATION_DIR}/${file}")
      
      list(APPEND resource_input_files ${src})
      add_custom_command(DEPENDS ${src}
                          COMMAND ${CMAKE_COMMAND} -E copy ${src} ${tgt}
                          OUTPUT ${tgt}
                          COMMENT "Copying python resource: ${file}")
      list(APPEND copied_resource_files ${tgt})
    endforeach()
    add_custom_target(Copy${MY_TARGET_NAME}PythonResourceFiles ALL
      DEPENDS
        ${resource_input_files} 
        ${copied_resource_files}
        )
  endif()

  set(MY_DIRECTORY_TO_INSTALL ${MY_DESTINATION_DIR})
  if(MY_NO_INSTALL_SUBDIR)
    set(MY_DIRECTORY_TO_INSTALL ${MY_DESTINATION_DIR}/)
  endif()

  # Install python module / resources directory
  install(DIRECTORY "${MY_DIRECTORY_TO_INSTALL}"
    DESTINATION "${MY_INSTALL_DIR}" COMPONENT RuntimeLibraries
    USE_SOURCE_PERMISSIONS)
       
endmacro()

