/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/

#ifndef QmitkExtWorkbenchWindowAdvisorHack_h
#define QmitkExtWorkbenchWindowAdvisorHack_h

#include <QObject>

class ctkPluginContext;
class QmitkPreferencesDialog;

class QmitkExtWorkbenchWindowAdvisorHack : public QObject
{
  Q_OBJECT

  public slots:

    void onUndo();
    void onRedo();
    void onImageNavigator();
    void onViewNavigator();
    void onEditPreferences(const QString& selectedPage = "");
    void onQuit();

    void onResetPerspective();
    void onClosePerspective();
    void onNewWindow();
    void onIntro();

    /**
     * @brief This slot is called if the user clicks the menu item "help->context help" or presses F1.
     * The help page is shown in a workbench editor.
     */
    void onHelp();

    void onHelpOpenHelpPerspective();

    /**
     * @brief This slot is called if the user clicks in help menu the about button
     */
    void onAbout();

  public:

    QmitkExtWorkbenchWindowAdvisorHack();
    ~QmitkExtWorkbenchWindowAdvisorHack() override;

    static QmitkExtWorkbenchWindowAdvisorHack* undohack;
};

#endif
