/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/


#ifndef mitkDataNodeObject_h
#define mitkDataNodeObject_h

#include <berryObject.h>
#include <berryMacros.h>

#include <org_mitk_gui_common_Export.h>

#include <mitkDataNode.h>
#include <mitkWeakPointer.h>

namespace mitk
{

/**
 * \ingroup org_mitk_gui_common
 */
class MITK_GUI_COMMON_PLUGIN DataNodeObject : public berry::Object
{

public:

  berryObjectMacro(mitk::DataNodeObject);

  DataNodeObject();
  DataNodeObject(DataNode* node);

  DataNode::Pointer GetDataNode() const;

  bool operator==(const berry::Object* obj) const override;

private:
  WeakPointer<DataNode> m_Node;

};

}

#endif
