/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/

#include "berryPreferenceConstants.h"

namespace berry
{

const std::string PreferenceConstants::OPEN_ON_SINGLE_CLICK = "OPEN_ON_SINGLE_CLICK";
const std::string PreferenceConstants::SELECT_ON_HOVER = "SELECT_ON_HOVER";
const std::string PreferenceConstants::OPEN_AFTER_DELAY = "OPEN_AFTER_DELAY";
const std::string PreferenceConstants::COLOR_ICONS = "COLOR_ICONS";
const std::string PreferenceConstants::EDITORS = "editors";
const std::string PreferenceConstants::RESOURCES = "resourcetypes";
const std::string PreferenceConstants::PERSPECTIVES = "perspectives";
const std::string PreferenceConstants::REUSE_EDITORS = "REUSE_OPEN_EDITORS";
const std::string PreferenceConstants::REUSE_DIRTY_EDITORS = "REUSE_DIRTY_EDITORS";
const std::string PreferenceConstants::REUSE_EDITORS_BOOLEAN = "REUSE_OPEN_EDITORS_BOOLEAN";
const std::string PreferenceConstants::RECENT_FILES = "RECENT_FILES";
const std::string PreferenceConstants::OPEN_VIEW_MODE = "OPEN_VIEW_MODE";
const int PreferenceConstants::OVM_EMBED = 0;
const int PreferenceConstants::OVM_FAST = 1;
const int PreferenceConstants::OVM_FLOAT = 2;
const std::string PreferenceConstants::OPEN_PERSP_MODE = "OPEN_PERSPECTIVE_MODE";
const int PreferenceConstants::OPM_ACTIVE_PAGE = 0;
const int PreferenceConstants::OPM_NEW_WINDOW = 2;
const std::string PreferenceConstants::ENABLED_DECORATORS = "ENABLED_DECORATORS";
const std::string PreferenceConstants::STICKY_CYCLE = "STICKY_CYCLE";
const std::string PreferenceConstants::PLUGINS_NOT_ACTIVATED_ON_STARTUP = "PLUGINS_NOT_ACTIVATED_ON_STARTUP";
const char PreferenceConstants::SEPARATOR = ';';
const std::string PreferenceConstants::DEFAULT_EDITORS = "defaultEditors";
const std::string PreferenceConstants::DEFAULT_EDITORS_CACHE = "defaultEditorsCache";
const std::string PreferenceConstants::EDITOR_TAB_WIDTH = "EDITOR_TAB_WIDTH";
const std::string PreferenceConstants::EDITORLIST_PULLDOWN_ACTIVE = "EDITORLIST_PULLDOWN_ACTIVE";
const std::string PreferenceConstants::EDITORLIST_SELECTION_SCOPE = "EDITORLIST_SELECTION_SCOPE";
const int PreferenceConstants::EDITORLIST_SET_WINDOW_SCOPE = 0;
const int PreferenceConstants::EDITORLIST_SET_PAGE_SCOPE = 1;
const int PreferenceConstants::EDITORLIST_SET_TAB_GROUP_SCOPE = 2;
const std::string PreferenceConstants::EDITORLIST_SORT_CRITERIA = "EDITORLIST_SORT_CRITERIA";
const int PreferenceConstants::EDITORLIST_NAME_SORT = 0;
const int PreferenceConstants::EDITORLIST_MRU_SORT = 1;
const std::string PreferenceConstants::EDITORLIST_DISPLAY_FULL_NAME = "EDITORLIST_DISPLAY_FULL_NAME";
const std::string PreferenceConstants::OVERRIDE_PRESENTATION = "overridepresentation"; //$
const std::string PreferenceConstants::KEYS_PREFERENCE_SELECTED_TAB = "KEYS_PREFERENCE_SELECTED_TAB";
const std::string PreferenceConstants::MULTI_KEY_ASSIST = "MULTI_KEY_ASSIST";
const std::string PreferenceConstants::MULTI_KEY_ASSIST_TIME = "MULTI_KEY_ASSIST_TIME";
const std::string PreferenceConstants::USE_IPERSISTABLE_EDITORS = "USE_IPERSISTABLE_EDITORS";
const std::string PreferenceConstants::RUN_IN_BACKGROUND = "RUN_IN_BACKGROUND";
const std::string PreferenceConstants::SHOULD_PROMPT_FOR_ENABLEMENT = "shouldPromptForEnablement";

}
