/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/

#ifndef mitkLogMessage_h
#define mitkLogMessage_h

#include <mitkLogLevel.h>

#include <string>

#include <MitkLogExports.h>

namespace mitk
{
  /** \brief A single log message (log event) of the MITK log mechanism.
   *
   * Logging messages should only be generated by the macros provided by mitkLog.h
   */

  struct MITKLOG_EXPORT LogMessage
  {
  public:
    LogMessage(const LogLevel level, const std::string& filePath, const int lineNumber, const std::string& functionName);

    /** \brief Log level of the emitted log message.
     */
    const LogLevel Level;

    /** \brief File name of the source file where the log message was emitted.
     */
    const std::string FilePath;

    /** \brief Line of the source source file where the log message was emitted.
     */
    const int LineNumber;

    /** \brief Name of the method where the log message was emitted.
     */
    const std::string FunctionName;

    /** \brief Name of the module where the log message was emitted.
     */
    std::string ModuleName;

    /** \brief Category of the log event, which was defined by the user.
     */
    std::string Category;

    /** \brief The actual log message.
     */
    std::string Message;
  };
}

#endif
