# MitkSplit4Dto3DImage User Guide {#MitkSplit4Dto3DImagePage}

[TOC]

## Overview

**MitkSplit4Dto3DImage** is a command-line application provided by the Medical Imaging Interaction Toolkit (MITK) for splitting a 4D image into separate 3D images per time point. This tool is useful for dynamic image analysis or when further processing must be applied to individual time frames.

All temporo-spatial properties associated with the input image are preserved and transferred to the respective time-point outputs when possible.


## Usage

```bash
MitkSplit4Dto3DImage -i <input_file> -o <output_pattern>
```

### Required Arguments

| Argument | Short | Type | Description |
|----------|-------|------|-------------|
| --input | -i | File | Path to the input 4D image file. If the image has only one time point, it will be saved directly as the output. |
| --output | -o | File path (pattern) | Output file path pattern. For multiple time steps, a numeric suffix (`_0`, `_1`, etc.) is added before the extension. |

### Optional Arguments

| Argument | Short | Type | Description |
|----------|-------|------|-------------|
| --help | -h | Flag | Show help text and usage information. |


## Details

### Output Naming Convention

If the input image contains more than one time step, the output filenames will be generated by appending the time step index to the base output filename:

```bash
<basename>_0<extension>, <basename>_1<extension>, ...
```

For example, for output pattern `result.nrrd`, and an input with 3 time steps:

- `result_0.nrrd`
- `result_1.nrrd`
- `result_2.nrrd`

If the input image contains only one time step, the output will be saved as is, with no suffix added.

### Property Handling

Temporo-spatial properties from the input image are preserved and transferred to the corresponding output images when possible:

- Static properties are cloned as-is.
- Time-dependent properties are extracted for the specific time step using MITK’s `TemporoSpatialStringProperty` interface.


## Examples

### Example 1: Split a 4D image into 3D time frames

```bash
MitkSplit4Dto3DImage -i dynamic_image.nii.gz -o time_frame.nrrd
```

**What happens:**

- Each time step in `dynamic_image.nii.gz` is saved as a separate file:
  - `time_frame_0.nrrd`
  - `time_frame_1.nrrd`
  - etc.

**Notes:**
- Temporo-spatial metadata (e.g., acquisition time or labels) is preserved for each output.

---

### Example 2: Input with only one time step

```bash
MitkSplit4Dto3DImage -i static_image.nrrd -o result.nrrd
```

**What happens:**

- Since the image has only one time point, it is saved directly as `result.nrrd` without modification or suffix.

---

## Supported Input and Output Formats

All image formats supported by MITK:

- **Input:** `.nrrd`, `.nii`, `.nii.gz`, `.mhd`, `.mha`, `.dcm` (via DICOM plugin), etc.
- **Output:** Typically `.nrrd`, `.nii`, `.nii.gz`, `.mhd`, `.mha`, depending on the file extension provided.


## Errors and Troubleshooting

- If no arguments are provided, the application exits without doing any work.
- An exception is thrown if image loading fails or output cannot be written.
- Ensure all input paths are correct and writable, and that MITK supports the file format.
