/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/

#include "QmitkLoadMultiLabelPresetAction.h"

#include <mitkLabelSetImage.h>

#include <QmitkMultiLabelPresetHelper.h>


void QmitkLoadMultiLabelPresetAction::Run(const QList<mitk::DataNode::Pointer> &selectedNodes)
{
  std::vector<mitk::MultiLabelSegmentation::Pointer> segmentations;

  for (const auto &node : selectedNodes)
  {
    if (node.IsNull())
      continue;

    mitk::MultiLabelSegmentation::Pointer segmentation = dynamic_cast<mitk::MultiLabelSegmentation*>(node->GetData());

    if (segmentation.IsNull())
      continue;

    segmentations.emplace_back(segmentation);
  }
  QmitkLoadMultiLabelPreset(segmentations);
}

void QmitkLoadMultiLabelPresetAction::SetDataStorage(mitk::DataStorage*)
{
}

void QmitkLoadMultiLabelPresetAction::SetFunctionality(berry::QtViewPart*)
{
}

void QmitkLoadMultiLabelPresetAction::SetSmoothed(bool)
{
}

void QmitkLoadMultiLabelPresetAction::SetDecimated(bool)
{
}
