/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/

#ifndef VIEWERPERSPECTIVE_H_
#define VIEWERPERSPECTIVE_H_

#include <berryIPerspectiveFactory.h>

#include <QObject>

/**
 * \brief Perspective class used as viewer perspective within the custom viewer plug-in.
 *
 * This is the perspective class that is used as viewer perspective within the custom viewer
 * plug-in. The ViewerPerspective holds an instance of each the QmitkDataManagerView and the
 * SimpleRenderWindowView. The editor area is made invisible, and QmitkDataManagerView and
 * the SimpleRenderWindowView instances are integrated as non-closeable fixated standalone views.
 */
// //! [ViewerPerspectiveClassDeclaration]
class ViewerPerspective : public QObject, public berry::IPerspectiveFactory
{
  Q_OBJECT
  Q_INTERFACES(berry::IPerspectiveFactory)

public:
  ViewerPerspective();

  /**
  * An instance of each the QmitkDataManagerView and the SimpleRenderWindowView are
  * initially being laid out.
  */
  void CreateInitialLayout(berry::IPageLayout::Pointer layout) override;
};
// //! [ViewerPerspectiveClassDeclaration]

#endif /* VIEWERPERSPECTIVE_H_ */
