/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/


#ifndef mitkRegVisPropertyTags_h
#define mitkRegVisPropertyTags_h

// MITK
#include "MitkMatchPointRegistrationExports.h"

namespace mitk
{
const char* const nodeProp_RegVisGrid = "matchpoint.RegVis.Grid";
const char* const nodeProp_RegVisGlyph = "matchpoint.RegVis.Glyph";
const char* const nodeProp_RegVisPoints = "matchpoint.RegVis.Points";
const char* const nodeProp_RegVisDirection = "matchpoint.RegVis.Direction";
const char* const nodeProp_RegVisFOVSize = "matchpoint.RegVis.FOV.size";
const char* const nodeProp_RegVisFOVOrigin = "matchpoint.RegVis.FOV.origin";
const char* const nodeProp_RegVisFOVSpacing = "matchpoint.RegVis.FOV.spacing";
const char* const nodeProp_RegVisFOVOrientation1 = "matchpoint.RegVis.FOV.orientation.row.1";
const char* const nodeProp_RegVisFOVOrientation2 = "matchpoint.RegVis.FOV.orientation.row.2";
const char* const nodeProp_RegVisFOVOrientation3 = "matchpoint.RegVis.FOV.orientation.row.3";
const char* const nodeProp_RegVisGridFrequence = "matchpoint.RegVis.Grid.Frequence";
const char* const nodeProp_RegVisGridShowStart = "matchpoint.RegVis.Grid.ShowStart";
const char* const nodeProp_RegVisColorStyle = "matchpoint.RegVis.ColorStyle";
const char* const nodeProp_RegVisGridStartColor = "matchpoint.RegVis.Grid.StartColor";
const char* const nodeProp_RegVisColorUni = "matchpoint.RegVis.Color.uni";
const char* const nodeProp_RegVisColor1Value = "matchpoint.RegVis.Color.1.value";
const char* const nodeProp_RegVisColor1Magnitude = "matchpoint.RegVis.Color.1.magnitude";
const char* const nodeProp_RegVisColor2Value = "matchpoint.RegVis.Color.2.value";
const char* const nodeProp_RegVisColor2Magnitude = "matchpoint.RegVis.Color.2.magnitude";
const char* const nodeProp_RegVisColor3Value = "matchpoint.RegVis.Color.3.value";
const char* const nodeProp_RegVisColor3Magnitude = "matchpoint.RegVis.Color.3.magnitude";
const char* const nodeProp_RegVisColor4Value = "matchpoint.RegVis.Color.4.value";
const char* const nodeProp_RegVisColor4Magnitude = "matchpoint.RegVis.Color.4.magnitude";
const char* const nodeProp_RegVisColorInterpolate = "matchpoint.RegVis.ColorInterpolate";
const char* const nodeProp_RegEvalStyle = "matchpoint.RegEval.Style";
const char* const nodeProp_RegEvalBlendFactor = "matchpoint.RegEval.BlendFactor";
const char* const nodeProp_RegEvalCheckerCount = "matchpoint.RegEval.CheckerCount";
const char* const nodeProp_RegEvalWipeStyle = "matchpoint.RegEval.WipeStyle";
const char* const nodeProp_RegEvalTargetContour = "matchpoint.RegEval.TargetContour";
const char* const nodeProp_RegEvalCurrentPosition = "matchpoint.RegEval.CurrentPosition";
}


#endif
