/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/

#ifndef _mbilogLogMessage_H
#define _mbilogLogMessage_H

#include <string>

#include "mbilogExports.h"

namespace mbilog
{
  /** Documentation
   *  \brief An object of this class represents a single logging message (logging event) of the
   *  mbi logging mechanism. Logging message should only be generated by the macros in the class mbilog.h
   *
   *  \ingroup mbilog
   */

  // todo convert to Struct
  class MBILOG_EXPORT LogMessage
  {
  public:
    // TODO: all member names m_[...]

    /** \brief Logging level which is defined in the enum mbilogLoggingTypes.h TODO: convert to enum.*/
    const int level;

    // the data of the following section is generated by the c-compiler

    /** \brief File name of the source file where the logging message was emitted which is generated by the macros in
     * file mbilog.h*/
    const char *filePath;
    /** \brief Line of the source source file where the logging message was emitted which is generated by the macros in
     * file mbilog.h*/
    const int lineNumber;
    /** \brief Name of the method where the logging message was emitted which is generated by the macros in file
     * mbilog.h*/
    const char *functionName;

    // the data of the following section is generated by the mitk module system

    /** \brief Name of the module where the logging message was emitted which is generated by the macros in file
     * mbilog.h. Is empty if there module defined.*/
    const char *moduleName;

    // user parameters

    /** \brief Category of the logging event, which was defined by the user.*/
    std::string category;

    /** \brief The actual logging message.*/
    std::string message;

    LogMessage(const int _level, const char *_filePath, const int _lineNumber, const char *_functionName)
      : level(_level), filePath(_filePath), lineNumber(_lineNumber), functionName(_functionName)
    {
    }
  };
}

#endif
