/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/

#ifndef __IGTL_STATUS_H // Same include guard as OpenIGTLink's igtl_status.h file
#define __IGTL_STATUS_H

// Internal status codes from OpenIGTLink's igtl_status.h file

#define IGTL_STATUS_INVALID              0
#define IGTL_STATUS_OK                   1
#define IGTL_STATUS_UNKNOWN_ERROR        2
#define IGTL_STATUS_PANICK_MODE          3
#define IGTL_STATUS_NOT_FOUND            4
#define IGTL_STATUS_ACCESS_DENIED        5
#define IGTL_STATUS_BUSY                 6
#define IGTL_STATUS_TIME_OUT             7
#define IGTL_STATUS_OVERFLOW             8
#define IGTL_STATUS_CHECKSUM_ERROR       9
#define IGTL_STATUS_CONFIG_ERROR        10
#define IGTL_STATUS_RESOURCE_ERROR      11
#define IGTL_STATUS_ILLEGAL_INSTRUCTION 12
#define IGTL_STATUS_NOT_READY           13
#define IGTL_STATUS_MANUAL_MODE         14
#define IGTL_STATUS_DISABLED            15
#define IGTL_STATUS_NOT_PRESENT         16
#define IGTL_STATUS_UNKNOWN_VERSION     17
#define IGTL_STATUS_HARDWARE_FAILURE    18
#define IGTL_STATUS_SHUT_DOWN           19

#endif
