/*============================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center (DKFZ)
All rights reserved.

Use of this source code is governed by a 3-clause BSD license that can be
found in the LICENSE file.

============================================================================*/

#include "mitkPluginActivator.h"
#include "src/internal/videoplayer/QmitkVideoPlayer.h"
#include <mitkPersistenceService.h>

namespace mitk
{
  void PluginActivator::start(ctkPluginContext *context)
  {
    mitk::PersistenceService::LoadModule();

    BERRY_REGISTER_EXTENSION_CLASS(QmitkVideoPlayer, context)
  }

  void PluginActivator::stop(ctkPluginContext *context) { Q_UNUSED(context) }
}
