/*===================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center,
Division of Medical and Biological Informatics.
All rights reserved.

This software is distributed WITHOUT ANY WARRANTY; without
even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE.

See LICENSE.txt or http://www.mitk.org for details.

===================================================================*/
#ifndef _QEMBED_1804289383
#define _QEMBED_1804289383
#include <qimage.h>
#include <qdict.h>
static const QRgb QmitkDiffusionTensorEstimation_data[] = {
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3c001eea,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x1a0a1d00,0x611a1800,0x8c311200,0x883c000d,0x55300051,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x621a1700,0xdd171200,0xfe341600,0xfe6b1400,0xf9960d00,0xf6b21600,0x6eb01000,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x1ace0014,0x27d10d00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x8a110f00,0xf40d0f00,0xf7341400,0xef6b0f00,0xf19d1200,0xf3c51200,0xf2e60c00,0xefe91000,0x40c70c00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3fca0c00,0x3aaff00,0x3aaff00,0x81121000,0xfb0f1100,0xf1251100,
    0xf05b1000,0xf38c1600,0xf2b80e00,0xf6df1800,0xedfc0400,0xf5ff1400,0xb3f41100,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x35f10e00,0x561b1800,0xf40d0f00,0xf0181000,0xee451000,0xef761100,0xeea30c00,0xeece0a00,
    0xdef40e00,0xd7ff1400,0xf5ff1400,0xebfd1700,0x1ded2300,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x38760e00,0xe51a1000,0xf6131400,0xf2331200,0xf4651300,0xf38c1600,0xf5b31700,0xffd11a11,0xfff52d21,0xffff3928,0xffff1d0a,
    0xf5ff1400,0x44ec1a00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x86110f00,0xfa0e1100,0xee190f00,0xf24d1100,0xf0751100,0xf19d1200,0xf6c30f00,0xffdf1e12,0xffff5749,0xffff6f5f,0xffff2016,0xf5ff1400,0x55fc0f00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x23071600,0xe7121300,0xf6131400,0xf2331200,
    0xef5c1000,0xee850e00,0xf1a91400,0xeece0a00,0xffee251c,0xfffe8272,0xfffe9080,0xffff2d1f,0xf5ff1400,0x5fff1500,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x7a131100,0xfb0f1100,0xee190f00,0xef430f00,0xee6b0f00,0xef911000,0xf4b41700,
    0xf3d41600,0xfff62f22,0xffff8575,0xffff7d6b,0xffff2016,0xf5ff1400,0x47ff0700,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0xc70e1200,0xfc161600,0xef251000,0xee510e00,0xee7a0c00,0xf19d1200,0xf0bb1000,0xeddd0d00,0xfffa3325,0xfffe6d5d,
    0xffff5543,0xffff2016,0xf5ff1400,0x35f10e00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x2e270600,0xf0111200,0xf2151100,0xf0361000,0xed600c00,0xee850e00,0xf4a71500,0xf3c51200,0xf4e40b00,0xffff2d1f,0xffff4639,0xffff3021,0xffff1d0a,0xe0ff1000,
    0x9c61c00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x5339900,0x1000df10,0x180bd400,0x70093b00,0xf9101700,0xf0181000,
    0xef430f00,0xef6b0f00,0xf1900f00,0xefae0e00,0xeece0a00,0xefe91000,0xeaff0a00,0xe9ff0b00,0xf5ff1400,0xf5ff1400,0xcbf11d00,0x3912ce00,0x3912ce00,0x3912ce00,
    0x3005c500,0x3812d100,0x3c00d50d,0x3005c500,0x2e06d300,0x2e06d300,0x2e06d300,0x2c06dc00,0x9e0d3f00,0xf70b1700,0xf1251100,0xef4e1100,0xf0751100,0xf39a1100,
    0xf3b80e00,0xf6d01400,0xefe91000,0xeaff0a00,0xf5ff1400,0xf5ff1400,0xf5ff1400,0x7ef71000,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0xa90c0c00,0xf70d1100,0xf32f1400,0xf15b1000,0xf2801200,0xf09d1200,0xf0bb1000,0xf1d80800,0xefe91000,
    0xf5ff1400,0xf5ff1400,0xf5ff1400,0xf5ff1400,0x2ffa1b00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0xb9151100,0xfc161600,0xef361000,0xf2651200,0xee850e00,0xf4a71500,0xf4c41100,0xeedc0c00,0xf5f10f00,0xf5ff1400,0xf5ff1400,0xf5ff1400,
    0xb6ff1400,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0xb8151100,
    0xfa181400,0xf2401300,0xef6a0e00,0xf28e0f00,0xf0ad0d00,0xf3c51200,0xf6df1800,0xf4f21100,0xf5ff1400,0xf5ff1400,0xf5ff1400,0x45fb1200,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0xa4191400,0xfd1a1500,0xef430f00,0xf3701500,
    0xef911000,0xefae0e00,0xeece0a00,0xf6df1800,0xf4f21100,0xf0fa0100,0xfcfa0c00,0xa7f91200,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x7c131000,0xff1b1600,0xf54a1600,0xf1741100,0xf49a1100,0xf4b41700,0xeece0a00,
    0xf2e60c00,0xf4f21100,0xf5ff1400,0xeaf10400,0x27f80007,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x37050e00,0xf2151100,0xf54a1600,0xf0751100,0xf29b1200,0xf2b80e00,0xf6d01400,0xf2e60c00,0xf5f10f00,0xf1f51200,
    0x68f00c00,0x2cb90600,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0xb4171200,0xfb421100,0xf0751100,0xf29b1200,0xf1b90f00,0xf6d01400,0xf4e40b00,0xfce91a00,0x66eb1400,0x3aaff00,0x31c60005,0x1ace0014,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x2b061200,
    0xd8321100,0xfa6f0e00,0xf7970e00,0xf5b50b00,0xfbcc0f00,0xdbd91500,0x50d20d00,0x3aaff00,0x3aaff00,0x3aaff00,0x3fca0c00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x23330700,0xa3430010,0xbc890e00,
    0xbaaa1600,0x6dbd0c00,0x1bd03900,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x21d11700,0x2ed30006,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x56600cc,0x2b002af9,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x37cc0009,0xab31900,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x2d0600d2,0x18002adf,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,
    0x3aaff00,0x3aaff00,0xeed0000,0x3cd50d00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00,0x3aaff00
};

/* Generated by qembed */
static struct EmbedImage {
    int width, height, depth;
    const unsigned char *data;
    int numColors;
    const QRgb *colorTable;
    bool alpha;
    const char *name;
} embed_image_vec[] = {
    { 25, 25, 32, (const unsigned char*)QmitkDiffusionTensorEstimation_data, 0, 0, TRUE, "QmitkDiffusionTensorEstimation" },
    { 0, 0, 0, 0, 0, 0, 0, 0 }
};

static const QImage& qembed_findImage( const QString& name )
{
    static QDict<QImage> dict;
    QImage* img = dict.find( name );
    if ( !img ) {
  for ( int i = 0; embed_image_vec[i].data; i++ ) {
      if ( strcmp(embed_image_vec[i].name, name.latin1()) == 0 ) {
    img = new QImage((uchar*)embed_image_vec[i].data,
          embed_image_vec[i].width,
          embed_image_vec[i].height,
          embed_image_vec[i].depth,
          (QRgb*)embed_image_vec[i].colorTable,
          embed_image_vec[i].numColors,
          QImage::BigEndian );
    if ( embed_image_vec[i].alpha )
        img->setAlphaBuffer( TRUE );
    dict.insert( name, img );
    break;
      }
  }
  if ( !img ) {
      static QImage dummy;
      return dummy;
  }
    }
    return *img;
}

#endif
