/*===================================================================

BlueBerry Platform

Copyright (c) German Cancer Research Center,
Division of Medical and Biological Informatics.
All rights reserved.

This software is distributed WITHOUT ANY WARRANTY; without
even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE.

See LICENSE.txt or http://www.mitk.org for details.

===================================================================*/

#include "berryWorkbenchRegistryConstants.h"

#include "berryPlatformUI.h"

namespace berry {

  const QString WorkbenchRegistryConstants::ATT_ACCELERATOR = "accelerator"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_ADAPTABLE = "adaptable"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_ADVISORID = "triggerPointAdvisorId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_ALLOW_LABEL_UPDATE = "allowLabelUpdate";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_ALLOW_MULTIPLE = "allowMultiple"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_RESTORABLE = "restorable";

  const QString WorkbenchRegistryConstants::ATT_CAN_FINISH_EARLY = "canFinishEarly"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CATEGORY = "category"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CATEGORY_ID = "categoryId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CLASS = "class"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CLOSEABLE = "closeable"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_COLORFACTORY = "colorFactory"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_COMMAND = "command";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_COMMAND_ID = "commandId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CONFIGURATION = "configuration"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CONTENT_DETECTOR = "contentDetector"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CONTENT_TYPE_ID = "contentTypeId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CONTEXT_ID = "contextId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CONTRIBUTOR_CLASS = "contributorClass"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_CONVERTER = "converter"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_DEFAULT = "default";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_DEFAULT_HANDLER = "defaultHandler"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_DEFAULTS_TO = "defaultsTo"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_DEFINITION_ID = "definitionId";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_DESCRIPTION = "description"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_DESCRIPTION_IMAGE = "descriptionImage"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_DISABLEDICON = "disabledIcon";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_ENABLES_FOR = "enablesFor"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_EXTENSIONS = "extensions";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_FAST_VIEW_WIDTH_RATIO = "fastViewWidthRatio"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_FILENAMES = "filenames";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_FILL_MAJOR = "fillMajor";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_FILL_MINOR = "fillMinor";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_FIXED = "fixed";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_HAS_PAGES = "hasPages"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_HELP_CONTEXT_ID = "helpContextId";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_HELP_HREF = "helpHref"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_HOVERICON = "hoverIcon";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_ICON = "icon"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_ID = "id"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_IMAGE_STYLE = "imageStyle"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_IS_EDITABLE = "isEditable"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_KEY = "key"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_KEY_CONFIGURATION_ID = "keyConfigurationId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_KEY_SEQUENCE = "keySequence"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_LABEL = "label"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_LAUNCHER = "launcher";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_LIGHTWEIGHT = "lightweight"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_LOCALE = "locale"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_LOCATION = "location"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_MATCHING_STRATEGY = "matchingStrategy"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_MENU_ID = "menuId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_MENUBAR_PATH = "menubarPath";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_MNEMONIC = "mnemonic"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_MINIMIZED = "minimized"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_MOVEABLE = "moveable"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_NAME = "name"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_NAME_FILTER = "nameFilter"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_NODE = "node"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_OBJECTCLASS = "objectClass";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_OPTIONAL = "optional"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_OS = "os"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PARENT = "parent"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PARENT_CATEGORY = "parentCategory"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PARENT_ID = "parentId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PARENT_SCOPE = "parentScope"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PATH = "path"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PLATFORM = "platform"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_POSITION = "position"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PRESENTATIONID = "presentationId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PRODUCTID = "productId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PROJECT = "project";//$NON-NLS-1$  /**

  const QString WorkbenchRegistryConstants::ATT_PULLDOWN = "pulldown"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_RATIO = "ratio"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_RELATIONSHIP = "relationship";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_RELATIVE = "relative";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_RELATIVE_TO = "relativeTo"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_RETARGET = "retarget";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_RETURN_TYPE_ID = "returnTypeId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_ROLE = "role";

  const QString WorkbenchRegistryConstants::ATT_SCHEME_ID = "schemeId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_SCOPE = "scope"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_SEPARATORS_VISIBLE = "separatorsVisible"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_SEQUENCE = "sequence"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_SHOW_TITLE = "showTitle";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_SINGLETON = "singleton";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_SPLASH_ID = "splashId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_STANDALONE = "standalone";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_STATE = "state";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_STRING = "string"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_STYLE = "style";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_TARGET_ID = "targetID";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_TOOLBAR_PATH = "toolbarPath";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_TOOLTIP = "tooltip";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_TYPE = "type"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_TYPE_ID = "typeId"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_VALUE = "value"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_VISIBLE = "visible";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_WS = "ws"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::AUTOGENERATED_PREFIX = "AUTOGEN:::"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ACCELERATOR_CONFIGURATIONS = "acceleratorConfigurations"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ACCELERATOR_SCOPES = "acceleratorScopes"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ACTION_DEFINITIONS = "actionDefinitions"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ACTION_SET_PART_ASSOCIATIONS = "actionSetPartAssociations"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ACTION_SETS = "actionSets"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ACTIVITIES = "activities"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ACTIVITYSUPPORT = "activitySupport"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_BINDINGS = "bindings"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_BROWSER_SUPPORT = "browserSupport"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_COLOR_DEFINITIONS = "colorDefinitions"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_COMMAND_IMAGES = "commandImages"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_COMMANDS = "commands"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_CONTEXTS = "contexts"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_DECORATORS = "decorators"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_DROP_ACTIONS = "dropActions"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_EDITOR = "editors"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_EDITOR_ACTIONS = "editorActions"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ELEMENT_FACTORY = "elementFactories"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_ENCODINGS = "encodings"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_EXPORT = "exportWizards"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_FONT_DEFINITIONS = "fontDefinitions"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_HANDLERS = "handlers"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_HELPSUPPORT = "helpSupport"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_IMPORT = "importWizards"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_INTRO = "intro"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_KEYWORDS = "keywords"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_MENUS = "menus"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_MENU_CONTRIBUTION = "menuContribution"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_NEW = "newWizards"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_PERSPECTIVE_EXTENSIONS = "perspectiveExtensions"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_PERSPECTIVES = "perspectives"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_POPUP_MENU = "popupMenus"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_PREFERENCE_TRANSFER = "preferenceTransfer"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_PREFERENCES = "preferencePages"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_PRESENTATION_FACTORIES = "presentationFactories"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_PROPERTY_PAGES = "propertyPages"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_STARTUP = "startup"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_SPLASH_HANDLERS = "splashHandlers"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_SYSTEM_SUMMARY_SECTIONS = "systemSummarySections"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_THEMES = "themes"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_VIEW_ACTIONS = "viewActions"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_VIEWS = "views"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::PL_WORKINGSETS = "workingSets"; //$NON-NLS-1$

//  const QString WorkbenchRegistryConstants::EXTENSION_ACCELERATOR_CONFIGURATIONS = PlatformUI::PLUGIN_ID
//      + '.' + PL_ACCELERATOR_CONFIGURATIONS;
//
//  const QString WorkbenchRegistryConstants::EXTENSION_ACCELERATOR_SCOPES = PlatformUI::PLUGIN_ID
//      + '.' + PL_ACCELERATOR_SCOPES;

  const QString WorkbenchRegistryConstants::EXTENSION_ACTION_DEFINITIONS = PlatformUI::PLUGIN_ID()
      + '.' + PL_ACTION_DEFINITIONS;

//  const QString WorkbenchRegistryConstants::EXTENSION_ACTION_SETS = PlatformUI::PLUGIN_ID
//      + '.' + WorkbenchRegistryConstants::PL_ACTION_SETS;
//
//  const QString WorkbenchRegistryConstants::EXTENSION_BINDINGS = PlatformUI::PLUGIN_ID + '.'
//      + PL_BINDINGS;
//
//  const QString WorkbenchRegistryConstants::EXTENSION_COMMAND_IMAGES = PlatformUI::PLUGIN_ID
//      + '.' + PL_COMMAND_IMAGES;

  const QString WorkbenchRegistryConstants::EXTENSION_COMMANDS = PlatformUI::PLUGIN_ID() + '.'
      + PL_COMMANDS;

//  const QString WorkbenchRegistryConstants::EXTENSION_CONTEXTS = PlatformUI::PLUGIN_ID + '.'
//      + PL_CONTEXTS;
//
//  const QString WorkbenchRegistryConstants::EXTENSION_EDITOR_ACTIONS = PlatformUI::PLUGIN_ID
//      + '.' + PL_EDITOR_ACTIONS;

  const QString WorkbenchRegistryConstants::EXTENSION_HANDLERS = PlatformUI::PLUGIN_ID() + '.'
      + PL_HANDLERS;

  const QString WorkbenchRegistryConstants::EXTENSION_MENUS = PlatformUI::PLUGIN_ID() + '.'
      + PL_MENUS;

  const QString WorkbenchRegistryConstants::COMMON_MENU_ADDITIONS = PlatformUI::PLUGIN_ID() + '.'
      + PL_MENUS + '2';

  const QString WorkbenchRegistryConstants::EXTENSION_POPUP_MENUS = PlatformUI::PLUGIN_ID()
      + '.' + PL_POPUP_MENU;

  const QString WorkbenchRegistryConstants::EXTENSION_VIEW_ACTIONS = PlatformUI::PLUGIN_ID()
      + '.' + PL_VIEW_ACTIONS;

  const QString WorkbenchRegistryConstants::POSITION_AFTER = "after"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::POSITION_BEFORE = "before"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::POSITION_END = "end"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::POSITION_START = "start"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::STYLE_PULLDOWN = "pulldown"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::STYLE_RADIO = "radio"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::STYLE_TOGGLE = "toggle"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACCELERATOR_CONFIGURATION = "acceleratorConfiguration"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACCELERATOR_SCOPE = "acceleratorScope"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACTION = "action"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACTION_DEFINITION = "actionDefinition"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACTION_SET = "actionSet";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACTION_SET_PART_ASSOCIATION = "actionSetPartAssociation";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACTIVE_KEY_CONFIGURATION = "activeKeyConfiguration"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACTIVE_WHEN = "activeWhen"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ACTIVITY_IMAGE_BINDING = "activityImageBinding"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ADVISORPRODUCTBINDING = "triggerPointAdvisorProductBinding"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_BAR = "bar"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_CATEGORY = "category";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_CATEGORY_IMAGE_BINDING = "categoryImageBinding"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_CATEGORYDEFINITION = "themeElementCategory"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_CATEGORYPRESENTATIONBINDING = "categoryPresentationBinding"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_CLASS = ATT_CLASS;

  const QString WorkbenchRegistryConstants::TAG_COLORDEFINITION = "colorDefinition"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_COLOROVERRIDE = "colorOverride"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_COLORVALUE = "colorValue"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_COMMAND = "command"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_COMMAND_PARAMETER = "commandParameter"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_COMMAND_PARAMETER_TYPE = "commandParameterType"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_CONTENT_TYPE_BINDING = "contentTypeBinding"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_CONTEXT = "context"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_DATA = "data"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_DEFAULT_HANDLER = ATT_DEFAULT_HANDLER;

  const QString WorkbenchRegistryConstants::TAG_DESCRIPTION = "description"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_DYNAMIC = "dynamic"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_EDITOR = "editor";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_EDITOR_CONTRIBUTION = "editorContribution"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ENABLED_WHEN = "enabledWhen"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ENABLEMENT = "enablement"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ENTRY = "entry"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_FILTER = "filter"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_FONTDEFINITION = "fontDefinition"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_FONTOVERRIDE = "fontOverride"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_FONTVALUE = "fontValue"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_GROUP = "group"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_GROUP_MARKER = "groupMarker"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_HANDLER = "handler"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_HANDLER_SUBMISSION = "handlerSubmission"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_HINT = "hint"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_IMAGE = "image"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_KEY = "key"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_KEY_BINDING = "keyBinding"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_KEY_CONFIGURATION = "keyConfiguration"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_LOCATION = "location"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_LOCATION_URI = "locationURI"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_LAYOUT = "layout"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_MAPPING = "mapping"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_MENU = "menu"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_NEW_WIZARD_SHORTCUT = "newWizardShortcut";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_OBJECT_CONTRIBUTION = "objectContribution";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_ORDER = "order"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_PARAMETER = "parameter"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_PART = "part";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_PERSP_SHORTCUT = "perspectiveShortcut";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_PERSPECTIVE = "perspective";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_PERSPECTIVE_EXTENSION = "perspectiveExtension";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_PRIMARYWIZARD = "primaryWizard"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_REFERENCE = "reference"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SCHEME = "scheme"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SCOPE = "scope"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SELECTION = "selection"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SEPARATOR = "separator"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SETTINGS_TRANSFER = "settingsTransfer"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SHOW_IN_PART = "showInPart";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_STATE = "state"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SPLASH_HANDLER = "splashHandler"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SPLASH_HANDLER_PRODUCT_BINDING = "splashHandlerProductBinding"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_STICKYVIEW = "stickyView";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SUPPORT = "support"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_THEME = "theme";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_TRANSFER = "transfer";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_TRIGGERPOINT = "triggerPoint"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_TRIGGERPOINTADVISOR = "triggerPointAdvisor"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_VIEW = "view";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_VIEW_SHORTCUT = "viewShortcut";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_VIEW_CONTRIBUTION = "viewContribution"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_VIEWER_CONTRIBUTION = "viewerContribution"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_VISIBILITY = "visibility"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_VISIBLE_WHEN = "visibleWhen"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_WIDGET = "widget"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_CONTROL = "control"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_WIZARD = "wizard";//$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_WORKING_SET = "workingSet"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TYPE_GROUP = "group"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TYPE_ITEM = "item"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TYPE_MENU = "menu"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TYPE_WIDGET = "widget"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_TOOLBAR = "toolbar"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SERVICE_FACTORY = "serviceFactory"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SERVICE = "service"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATTR_FACTORY_CLASS = "factoryClass"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATTR_SERVICE_CLASS = "serviceClass"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_SOURCE_PROVIDER = "sourceProvider"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATTR_PROVIDER = "provider"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::TAG_VARIABLE = "variable"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_PRIORITY_LEVEL = "priorityLevel"; //$NON-NLS-1$

  const QString WorkbenchRegistryConstants::ATT_MODE = "mode";

} // namespace berry
