/*===================================================================

BlueBerry Platform

Copyright (c) German Cancer Research Center,
Division of Medical and Biological Informatics.
All rights reserved.

This software is distributed WITHOUT ANY WARRANTY; without
even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE.

See LICENSE.txt or http://www.mitk.org for details.

===================================================================*/


#ifndef BERRYIFOLDERLAYOUT_H_
#define BERRYIFOLDERLAYOUT_H_

#include "berryIPlaceholderFolderLayout.h"

namespace berry {

/**
 * \ingroup org_blueberry_ui_qt
 *
 * An <code>IFolderLayout</code> is used to define the initial views within a folder.
 * The folder itself is contained within an <code>IPageLayout</code>.
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 *
 * @see IPageLayout#createFolder
 * @noimplement This interface is not intended to be implemented by clients.
 */
struct BERRY_UI_QT IFolderLayout : public IPlaceholderFolderLayout
{

  berryObjectMacro(berry::IFolderLayout)

  ~IFolderLayout();

    /**
     * Adds a view with the given compound id to this folder.
     * See the {@link IPageLayout} type documentation for more details about compound ids.
     * The primary id must name a view contributed to the workbench's view extension point
     * (named <code>"org.blueberry.ui.views"</code>).
     *
     * @param viewId the view id
     */
    virtual void AddView(const QString& viewId) = 0;
};

}

#endif /*BERRYIFOLDERLAYOUT_H_*/
