/*===================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center,
Division of Medical and Biological Informatics.
All rights reserved.

This software is distributed WITHOUT ANY WARRANTY; without
even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE.

See LICENSE.txt or http://www.mitk.org for details.

===================================================================*/

#include "mitkFiberBundleTrackVisReader.h"
#include <itkMetaDataObject.h>
#include <vtkPolyData.h>
#include <vtkDataReader.h>
#include <vtkPolyDataReader.h>
#include <vtkMatrix4x4.h>
#include <vtkPolyLine.h>
#include <vtkCellArray.h>
#include <vtkDataArray.h>
#include <vtkFloatArray.h>
#include <vtkCellData.h>
#include <vtkPointData.h>
#include <itksys/SystemTools.hxx>
#include <tinyxml.h>
#include <vtkCleanPolyData.h>
#include <mitkTrackvis.h>
#include <mitkCustomMimeType.h>
#include "mitkDiffusionIOMimeTypes.h"


mitk::FiberBundleTrackVisReader::FiberBundleTrackVisReader()
    : mitk::AbstractFileReader( mitk::DiffusionIOMimeTypes::FIBERBUNDLE_TRK_MIMETYPE_NAME(), "TrackVis Fiber Bundle Reader" )
{
    m_ServiceReg = this->RegisterService();
}

mitk::FiberBundleTrackVisReader::FiberBundleTrackVisReader(const FiberBundleTrackVisReader &other)
    :mitk::AbstractFileReader(other)
{
}

mitk::FiberBundleTrackVisReader * mitk::FiberBundleTrackVisReader::Clone() const
{
    return new FiberBundleTrackVisReader(*this);
}

std::vector<itk::SmartPointer<mitk::BaseData> > mitk::FiberBundleTrackVisReader::Read()
{

    std::vector<itk::SmartPointer<mitk::BaseData> > result;
    try
    {
        const std::string& locale = "C";
        const std::string& currLocale = setlocale( LC_ALL, NULL );
        setlocale(LC_ALL, locale.c_str());

        std::string filename = this->GetInputLocation();

        std::string ext = itksys::SystemTools::GetFilenameLastExtension(filename);
        ext = itksys::SystemTools::LowerCase(ext);

        if (ext==".trk")
        {
            FiberBundle::Pointer image = FiberBundle::New();
            TrackVisFiberReader reader;
            reader.open(this->GetInputLocation().c_str());
            reader.read(image.GetPointer());
            result.push_back(image.GetPointer());
            return result;
        }

        setlocale(LC_ALL, currLocale.c_str());
        MITK_INFO << "Fiber bundle read";
    }
    catch(...)
    {
        throw;
    }
    return result;
}
