/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkDiffusionTensor3DReconstructionImageFilter.h,v $
  Language:  C++
  Date:      $Date: 2006-03-27 17:01:06 $
  Version:   $Revision: 1.12 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef __itkMrtrixPeakImageConverter_h_
#define __itkMrtrixPeakImageConverter_h_

#include <itkImageToImageFilter.h>
#include <itkVectorContainer.h>
#include <mitkFiberBundle.h>
#include <itkOrientationDistributionFunction.h>

namespace itk{
/** \class MrtrixPeakImageConverter
  Converts a series of 4D images containing directional (3D vector) information into a vector field stored as mitkFiberBundle.
  These 4D files are for example generated by the FSL qboot command.
*/

template< class PixelType >
class MrtrixPeakImageConverter : public ProcessObject
{

public:

  enum NormalizationMethods {
    NO_NORM,            ///< don't normalize peaks
    SINGLE_VEC_NORM     ///< normalize peaks to length 1
  };

  typedef MrtrixPeakImageConverter Self;
  typedef SmartPointer<Self>                      Pointer;
  typedef SmartPointer<const Self>                ConstPointer;
  typedef ProcessObject Superclass;

   /** Method for creation through the object factory. */
  itkFactorylessNewMacro(Self)
  itkCloneMacro(Self)

  /** Runtime information support. */
  itkTypeMacro(MrtrixPeakImageConverter, ImageToImageFilter)

  typedef vnl_vector_fixed< double, 3 >                                 DirectionType;
  typedef VectorContainer< int, DirectionType >                         DirectionContainerType;
  typedef VectorContainer< int, DirectionContainerType::Pointer >       ContainerType;
  typedef Image< float, 4 >                                             InputImageType;
  typedef Image< Vector< float, 3 >, 3>                                 ItkDirectionImageType;
  typedef VectorContainer< int, ItkDirectionImageType::Pointer >        DirectionImageContainerType;
  typedef itk::Image<unsigned char, 3>                                  ItkUcharImgType;

  itkSetMacro( NormalizationMethod, NormalizationMethods)                       ///< normalization method of ODF peaks
  itkSetMacro( InputImage, InputImageType::Pointer)                             ///< MRtrix direction image of type itk::Image< float, 4 >
  itkGetMacro( OutputFiberBundle, mitk::FiberBundle::Pointer)                  ///< vector field (peak sizes rescaled for visualization purposes)
  itkGetMacro( DirectionImageContainer, DirectionImageContainerType::Pointer)   ///< container for output peaks
  itkGetMacro( NumDirectionsImage, ItkUcharImgType::Pointer)                    ///< number of peaks per voxel

  void GenerateData() override;

protected:
  MrtrixPeakImageConverter();
  ~MrtrixPeakImageConverter(){}

  NormalizationMethods                  m_NormalizationMethod;          ///< normalization method of ODF peaks
  mitk::FiberBundle::Pointer           m_OutputFiberBundle;            ///< vector field (peak sizes rescaled for visualization purposes)
  InputImageType::Pointer               m_InputImage;                   ///< MRtrix direction image of type itk::Image< float, 4 >
  DirectionImageContainerType::Pointer  m_DirectionImageContainer;      ///< container for output peaks
  ItkUcharImgType::Pointer              m_NumDirectionsImage;           ///< number of peaks per voxel

private:

};

}

#ifndef ITK_MANUAL_INSTANTIATION
#include "itkMrtrixPeakImageConverter.cpp"
#endif

#endif //__itkMrtrixPeakImageConverter_h_

