Getting Started    {#MicroServices_GettingStarted}
===============

Projects which want to make use of the capabilities provided by the C++ Micro Services
library need to set-up the correct include paths and link dependencies. Further, each
executable or shared library which needs a ModuleContext instance must contain specific
initialization code and must be compiled with a unique `US_MODULE_NAME` pre-processor
definition. In case of executables, the value is required to be `main`, e.g. compile
the executable with `-DUS_MODULE_NAME=main`.

The C++ Micro Services library provides \ref MicroServicesCMake "CMake utility functions"
for CMake based projects but there are no restrictions on the type of build system used
for a project.

CMake based projects
--------------------

To easily set-up include paths and linker dependencies, use the common `find_package`
mechanism provided by CMake:

\dontinclude examples/CMakeLists.txt
\skip project
\until include_directories

The CMake code above sets up a basic project (called CppMicroServicesExamples) and tries
to find the CppMicroServices package and subsequently to set the necessary include
directories. Building a shared library might then look like this:

\dontinclude examples/dictionaryservice/CMakeLists.txt
\until target_link

The call to `#usFunctionGenerateModuleInit` generates the proper module initialization
code and provides access to the module specific ModuleContext instance. Further, the
`set_property`command sets the `US_MODULE_NAME` definition.

Makefile based projects
-----------------------

The following Makefile is located at examples/makefile/Makefile and demonstrates a minimal
build script:

\include makefile/Makefile

The variable `CppMicroServices_ROOT` is an environment variable and must be set to the
CppMicroServices installation directory prior to invoking `make`. The module initialization
code for the `libmodule.so` shared library is generated by using the `#US_INITIALIZE_MODULE`
pre-processor macro at the end of the `module.cpp` source file (any source file compiled
into the module would do):

\dontinclude makefile/module.cpp
\skip usModuleInitialization
\until US_INITIALIZE_MODULE
