/*===================================================================

The Medical Imaging Interaction Toolkit (MITK)

Copyright (c) German Cancer Research Center,
Division of Medical and Biological Informatics.
All rights reserved.

This software is distributed WITHOUT ANY WARRANTY; without
even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE.

See LICENSE.txt or http://www.mitk.org for details.

===================================================================*/

#include "mitkDicomSeriesReader.txx"

namespace mitk
{

Image::Pointer
DicomSeriesReader
::MultiplexLoadDICOMByITKScalar(const StringContainer& filenames, bool correctTilt, const GantryTiltInformation& tiltInfo, DcmIoType::Pointer& io, CallbackCommand* command, Image::Pointer preLoadedImageBlock)
{
  switch (io->GetComponentType())
  {
    case DcmIoType::UCHAR:
      return LoadDICOMByITK<unsigned char>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::CHAR:
      return LoadDICOMByITK<char>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::USHORT:
      return LoadDICOMByITK<unsigned short>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::SHORT:
      return LoadDICOMByITK<short>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::UINT:
      return LoadDICOMByITK<unsigned int>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::INT:
      return LoadDICOMByITK<int>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::ULONG:
      return LoadDICOMByITK<long unsigned int>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::LONG:
      return LoadDICOMByITK<long int>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::FLOAT:
      return LoadDICOMByITK<float>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    case DcmIoType::DOUBLE:
      return LoadDICOMByITK<double>(filenames, correctTilt, tiltInfo, io, command ,preLoadedImageBlock);
    default:
      MITK_ERROR << "Found unsupported DICOM scalar pixel type: (enum value) " << io->GetComponentType();
      return nullptr;
  }
}

} // end namespace mitk

#include <mitkDicomSeriesReader.txx>

