function(mitkFunctionEnableBuildConfiguration)

  if(MITK_BUILD_CONFIGURATION STREQUAL "Custom")
    return()
  endif()

  set(_build_config_file "${MITK_CMAKE_DIR}/BuildConfigurations/${MITK_BUILD_CONFIGURATION}.cmake")
  if(NOT EXISTS ${_build_config_file})
    message(WARNING "Unknown build configuration \"${MITK_BUILD_CONFIGURATION}\", falling back to \"Custom\" configuration.")
    return()
  endif()

  message(STATUS "------- Using build configuration \"${MITK_BUILD_CONFIGURATION}\" -------")
  include(${_build_config_file})

  if(MITK_CONFIG_PACKAGES)
    foreach(_package ${MITK_CONFIG_PACKAGES})
      if(DEFINED MITK_USE_${_package})
        if(NOT MITK_USE_${_package})
          message("> Enabling package ${_package} as requested by the build configuration")
          get_property(_is_cache CACHE MITK_USE_${_package} PROPERTY VALUE)
          if(DEFINED _is_cache)
           set(MITK_USE_${_package} ON CACHE BOOL "Use ${_package} in MITK" FORCE)
          else()
            set(MITK_USE_${_package} ON)
          endif()
        endif()
      else()
        message(SEND_ERROR "Unknown package name \"${_package}\" in build configuration \"${MITK_BUILD_CONFIGURATION}\"")
      endif()
    endforeach()
  endif()

  if(NOT MITK_USE_SUPERBUILD AND MITK_CONFIG_PLUGINS AND MITK_USE_BLUEBERRY)
    foreach(_plugin ${MITK_CONFIG_PLUGINS})
      if(DEFINED MITK_BUILD_${_plugin} AND NOT MITK_BUILD_${_plugin})
        message("> Enabling plug-in ${_plugin} as requested by the build configuration")
      endif()
      set(MITK_BUILD_${_plugin} ON CACHE BOOL "Build the ${_plugin} Plugin." FORCE)
    endforeach()
  endif()

endfunction()
